import pandas as pd   
import pickle
from decision_company import read_csv_file, logical_or, filter_by_condition

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Create conditions  
condition1 = high_credit_long_duration['employment'] == '4<=X<7'  
condition2 = high_credit_long_duration['employment'] == '>=7'  
  
# Perform logical OR operation  
final_condition = logical_or(condition1, condition2)  
  
# Filter the clients with stable employment (4 years or more)  
stable_employment = filter_by_condition(high_credit_long_duration, final_condition)  
  
print(f"stable_employment: {stable_employment}")  
pickle.dump(stable_employment, open("./ref_result/stable_employment.pkl","wb"))

  